#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

// Trim string in input
char *trim(char *s)
{
    char* back = s + strlen(s);
    while(isspace(*--back));
    *(back+1) = '\0';
    return s;
}

// match word with dict
int match(const char* dict, const char *word)
{
    FILE * file = NULL;
    char * line = NULL;
    size_t len;
    size_t read;

    int wordlen = strlen(word);

    file = fopen(dict, "r");

    while ((read = getline(&line, &len, file)) != -1) 
    {
        line = trim(line);

        // Skip if not same length
        if(wordlen != strlen(line))
        {
            continue;
        }

        int match = 1;

        // Match every character
        for (size_t i = 0; i < wordlen; i++)
        {
            if(word[i] != '?' && word[i] != line[i])
            {
                match = 0;
                break;
            }
        }
        
        // Print word when matching
        if(match)
        {
            printf("%s\n", line);
        }
    }

    if(line)
        free(line);
}

int main(int argc, char const *argv[])
{
    char * word = (char*) malloc(20 * sizeof(char));
    int wordlen = 0;

    printf("Word to guess >");

    int execute = 1;

    while(execute)
    {
        // Read one char from console
        char c = getchar();
        
        // Execute match when return
        if(c == '\n')
        {
            word[wordlen] = '\0';

            // Exit if no input
            if(wordlen == 0)
            {
                printf("Thanks for using me :> !\n");
                execute = 0;
                continue;
            }

            // Replace chars
            for (size_t i = 0; i < wordlen; i++)
            {
                if(word[i] == ' ' || word[i] == '_' )
                {
                    word[i] = '?';
                }
            }

            // Inform user and matchs
            printf("Words matching \"%s\" :\n", word);
            match("dictionary.txt", word);
            printf("New word to guees >");
            wordlen = 0;
        }
        else
        {
            word[wordlen++] = c;
        }
    }

    free(word);
    
    return 0;
}
